using System.Collections.Generic;
using UnityEngine;

namespace PokerTable
{
    public class BetButton : GameButton
    {
        public ActionList ButtonActionList;
        public override void Selected()
        {
            ButtonActionList.FadeObject(gameObject, HoverColor, 0.1f, 0.0f);
            ButtonActionList.ScaleObject(gameObject, scaleOriginal, 0.1f, 0.0f);
        }
        public override void Unselected()
        {
            ButtonActionList.FadeObject(gameObject, NormalColor, 0.1f, 0.0f);
            ButtonActionList.ScaleObject(gameObject, scaleOriginal, 0.1f, 0.0f);
        }
        public override void Pressed()
        {
            ButtonActionList.FadeObject(gameObject, PressedColor, 0.1f, 0.0f);
            ButtonActionList.ScaleObject(gameObject, scalePressed, 0.1f, 0.0f);
        }
        public override void PressAction(GameObject player)
        {
            player.GetComponent<Player>().Bet(1);
            // Debug.Log("BetButton Action");
        }
        public override void Awake()
        {
            // get a reference to the collider
            buttonCollider = gameObject.GetComponent<BoxCollider2D>();
            scaleOriginal = gameObject.transform.localScale;
            scalePressed = scaleOriginal + new Vector3 (0.1f, 0.1f, 0.0f);
            gameManagerObject= GameObject.Find("GameManager");
            uiManagerObject= GameObject.Find("UIManager");
            uiManager = uiManagerObject.GetComponent<UIManager>();
            actionList = isUI ? uiManagerObject.GetComponent<ActionList>() : gameManagerObject.GetComponent<ActionList>();
            ButtonActionList = GetComponentInParent<ActionList>();
        }

        public override void Update()
        {
            // buttonCollider.enabled = gameManagerObject.GetComponent<GameManager>().gameState == GameManager.STATE_PLAYER_TURN;

            if(gameManagerObject.GetComponent<GameManager>().gameState == GameManager.STATE_PLAYER_TURN &&
            !gameManagerObject.GetComponent<GameManager>().isAutoMode &&
            isUI == gameManagerObject.GetComponent<GameManager>().isUIon && 
            actionList.Actions.Count <= 0)
                buttonCollider.enabled = true;
            else
                buttonCollider.enabled = false;

        }
    }
}