using System.Collections.Generic;
using UnityEngine;

namespace PokerTable{
public class GameButton : MonoBehaviour
{
    [Header("Colors")]
    public Color NormalColor = new(1,1,1,1);
    public Color HoverColor;
    public Color PressedColor;
    [HideInInspector]
    protected BoxCollider2D buttonCollider;
    public Vector3 scaleOriginal;
    public Vector3 scalePressed;
    private bool isMouseOver = false;
    public bool isUI = false;
    public GameObject gameManagerObject; // Reference to the ActionList component.
    public GameObject uiManagerObject;
    public UIManager uiManager;
    public ActionList actionList; // Reference to the ActionList component.


    public virtual void Awake()
    {
        // get a reference to the collider
        buttonCollider = gameObject.GetComponent<BoxCollider2D>();
        scaleOriginal = gameObject.transform.localScale;
        scalePressed = scaleOriginal + new Vector3 (0.1f, 0.1f, 0.0f);
        gameManagerObject= GameObject.Find("GameManager");
        uiManagerObject= GameObject.Find("UIManager");
        uiManager = uiManagerObject.GetComponent<UIManager>();
        actionList = isUI ? uiManagerObject.GetComponent<ActionList>() : gameManagerObject.GetComponent<ActionList>();
    }
    public virtual void Selected()
    {
        actionList.FadeObject(gameObject, HoverColor, 0.1f, 0.0f);
        actionList.ScaleObject(gameObject, scaleOriginal, 0.1f, 0.0f);
    }
    public virtual void Unselected()
    {
        actionList.FadeObject(gameObject, NormalColor, 0.1f, 0.0f);
        actionList.ScaleObject(gameObject, scaleOriginal, 0.1f, 0.0f);
    }
    public virtual void Pressed()
    {
        actionList.FadeObject(gameObject, PressedColor, 0.1f, 0.0f);
        actionList.ScaleObject(gameObject, scalePressed, 0.1f, 0.0f);
    }
    // Code to execute when the mouse hovers over the GameObject
    void OnMouseEnter()
    {
        isMouseOver = true;
        Selected();
        // Debug.Log("Mouse entered!");
    }
    // Code to execute when the mouse stops hovering over the GameObject
    void OnMouseExit()
    {
        isMouseOver = false;
        Unselected();
        // Debug.Log("Mouse exited!");
    }
    void OnMouseDown()
    {
        Pressed();
        PressAction(gameManagerObject.GetComponent<GameManager>().playerList[0]);
        // Debug.Log("Mouse Down!");
    }
    void OnMouseUp()
    {
        if (isMouseOver)
        {
            Selected();
            // Debug.Log("Mouse Up!");
        }
    }

    public virtual void PressAction()
    {

    }
    public virtual void PressAction(GameObject player)
    {

    }
    public virtual void Update()
    {
        buttonCollider.enabled = isUI ? false : !gameManagerObject.GetComponent<GameManager>().isUIon;
    }
}
}