using System.Collections.Generic;
using UnityEngine;
using TMPro;

namespace PokerTable
{
    public class UIButton : GameButton
    {
        public bool isMain;
        private static float subMenuDuration = 0.3f;
        public GameObject textTMPro;
        Color colorOriginal;
        public int buttonPressed = 0;
        public override void Awake()
        {
            // get a reference to the collider
            buttonCollider = gameObject.GetComponent<BoxCollider2D>();
            scaleOriginal = gameObject.transform.localScale;
            scalePressed = scaleOriginal + new Vector3 (0.1f, 0.1f, 0.0f);
            gameManagerObject= GameObject.Find("GameManager");
            uiManagerObject= GameObject.Find("UIManager");
            uiManager = uiManagerObject.GetComponent<UIManager>();
            actionList = isUI ? uiManagerObject.GetComponent<ActionList>() : gameManagerObject.GetComponent<ActionList>();
            if(!isMain)
            {
                colorOriginal = HoverColor;
            }
            buttonPressed = 0;
        }
        public override void PressAction()
        {
            buttonPressed++;
            if(isMain)
            {
                uiManager.navigatingMain = false;
                //Get rid off other than this object, Move this object to the main menu position
                for(int i = 0; i < uiManager.MainOptionsList.Count; i++)
                {
                    if(i != uiManager.mainNavigator)
                    {
                        actionList.FadeObject(uiManager.MainOptionsList[i], Color.clear, 0.3f, 0.0f, false, 0, Action.EaseType.EaseOut);
                    }
                    else
                    {
                        actionList.TranslateObject(uiManager.MainOptionsList[i], uiManager.mainMenuPosition, 0.3f, -9.9f, 0, Action.EaseType.EaseIn);
                        actionList.ScaleObject(uiManager.MainOptionsList[i], new Vector3 (1.5f,1.5f,1.0f), 0.3f, 0.0f);
                    }
                }

                float buttonsGap = 1.0f;
                float timeGap = 0.0f;
                //Fade in, Spread out submenus
                for(int i = 0; i < 3; i++)
                {
                    if(i != uiManager.subNavigator)
                        actionList.FadeObject(uiManager.SubOptionsList[i], Color.white, subMenuDuration, 0.0f, false, 0, Action.EaseType.EaseIn);
                    else
                        actionList.FadeObject(uiManager.SubOptionsList[i], uiManager.SubOptionsList[i].GetComponent<UIButton>().HoverColor, subMenuDuration, 0.0f, false, 0, Action.EaseType.EaseIn);

                    actionList.TranslateObject(uiManager.SubOptionsList[i], uiManager.mainMenuPosition - new Vector3(0,buttonsGap,-9.9f), subMenuDuration, timeGap, 0, Action.EaseType.EaseIn);
                    actionList.RotateObjectAbsolute(uiManager.SubOptionsList[i], new Vector3(0,0,0), subMenuDuration, timeGap, 0, Action.EaseType.EaseIn);
                    timeGap += 0.1f;
                    buttonsGap += 1.0f;
                }
            }
            else
            {
                uiManager.navigatingMain = true;
                uiManager.subNavigator = 0;
                actionList.FadeObject(textTMPro, colorOriginal, new Color(colorOriginal.r, colorOriginal.g,colorOriginal.b,0), 0.3f, 0.0f, true);
                //Get in other than this object, Move main menu to the original position
                for(int i = 0; i < uiManager.MainOptionsList.Count; i++)
                {
                    if(i != uiManager.mainNavigator)
                        actionList.FadeObject(uiManager.MainOptionsList[i], Color.white, 0.3f, 0.0f, false, 0, Action.EaseType.EaseIn);
                    else
                    {
                        // actionList.FadeObject(uiManager.MainOptionsList[i], uiManager.MainOptionsList[i].GetComponent<UIButton>().HoverColor, 0.1f, 0.0f, false, 0, Action.EaseType.EaseIn);
                        actionList.ScaleObject(uiManager.MainOptionsList[i], new Vector3 (1.0f,1.0f,1.0f), 0.3f, 0.3f);
                    }
                        
                        actionList.TranslateObject(uiManager.MainOptionsList[i], new Vector3 (0, 2 - i, -9.9f), 0.3f, 0.3f, 0, Action.EaseType.EaseIn);
                }
                float timeGap = 0.3f;
                //Fade out, collect to the original position
                for(int i = 0; i < 3; i++)
                {
                    actionList.FadeObject(uiManager.SubOptionsList[i], Color.clear, subMenuDuration, 0.3f, false, 0, Action.EaseType.EaseOut);
                    actionList.TranslateObject(uiManager.SubOptionsList[i], new Vector3(0,-3, -9.9f), subMenuDuration, timeGap, 0, Action.EaseType.EaseOut);
                    actionList.RotateObjectAbsolute(uiManager.SubOptionsList[i], new Vector3(0,0,180), subMenuDuration, timeGap, 0, Action.EaseType.EaseOut);
                    timeGap += 0.1f;
                }
                // uiManager.MainOptionsList[uiManager.mainNavigator].GetComponent<GameButton>().Selected();
            }
            // going up this object, other than this, go out. generate suboptionslist, 
            // Debug.Log("UIButton Action");
        }
    }
}