using UnityEngine;

namespace PokerTable
{
    public class Card : MonoBehaviour
    {
        ActionList actionList;
        public SpriteRenderer cardFaceSprite;
        public Vector2 v2_value; // Vector2.x = Value, Vector2.y = Suit

        // [HideInInspector]
        // public CardData cardData = new();
        // // the card from the deck
        // CardData libraryCard;
        void Awake()
        {
            // Find the GameManager object by name
            GameObject gameManagerObject = GameObject.Find("GameManager");
            // Check if the GameManager object is found
            if (gameManagerObject != null)
            {
                // Get the ActionList component from the GameManager object
                actionList = gameManagerObject.GetComponent<ActionList>();
                // Check if the ActionList component is found
                if (actionList != null)
                {
                    // Now you can use the actionList component as needed
                }
                else
                {
                    Debug.LogError("ActionList component not found on GameManager object.");
                }
            }
            else
            {
                Debug.LogError("GameManager object not found.");
            }
        }

        void Start()
        {
        }
        public void UpdateCardFaceSprite(Vector2 cardValue)
        {
            Sprite cardImg = StaticData.getCardImage(cardValue);
            cardFaceSprite.sprite = cardImg;
        }
    }
}