using System.Collections;
using System.Collections.Generic;
using TMPro;
using UnityEngine;
using UnityEngine.UIElements;

namespace PokerTable{
public class Player : MonoBehaviour
{
    public string Name;
    public bool IsAI;
    public bool IsIn = false;
    public bool IsJoinMiddle = false;
    public bool HasActed = false;
    public bool IsFold = false;
    public bool IsWin = false;
    [HideInInspector]
    public GameObject gameManagerObject;
    [HideInInspector]
    public GameManager gameManager;
    [HideInInspector]
    public ActionList actionList;
    public List<GameObject> hand = new();
    public List<GameObject> tempHoldingChips;
    public List<GameObject> holdingChips;
    public Transform outScreen;
    public Transform chipStack;
    public BoxCollider2D cardPot;
    public BoxCollider2D chipPot;
    public GameObject nameTMPro;
    public Vector3 handsValue;
    public static float chipGap = 0.04f;
    public static float cardGap = 0.45f;

    public static class RandomPositionGenerator
    {
        // Generates a random position within the bounds of the target sprite
        public static Vector3 GenerateRandomPositionWithinCollider(BoxCollider2D targetSprite)
        {
            // Get the bounds
            Bounds bounds = targetSprite.bounds;

            // Generate a random position within the bounds
            float x = Random.Range(bounds.min.x, bounds.max.x);
            float y = Random.Range(bounds.min.y, bounds.max.y);

            // Return the generated position (z position is the same as the target sprite)
            return new Vector3(x, y);
        }
    }
    public static Vector3 GenerateRandomScatter(Vector3 min, Vector3 max)
    {
        float x = Random.Range(min.x, max.x);
        float y = Random.Range(min.y, max.y);
        float z = Random.Range(min.z, max.z);
        return new Vector3(x,y,z);
    }
    public void InitializeChipsFromOutscreen()
    {
        holdingChips = new();
        //Vector3 chipStartPosition = outScreen.localPosition;

        float delayBetween = 0.0f;
        for (int i = 0; i < gameManager.ChipPerPlayer; i++)
        {
            // Adjust the position for each chip based on the gap and index
            Vector3 chipPosition = new (0, chipGap * i, gameManager.ZDepthTable);

            // Instantiate the chip at the world position calculated from outScreen's position
            GameObject chip = Instantiate(gameManager.ChipPrefab, outScreen.TransformPoint(chipPosition), Quaternion.identity);
            tempHoldingChips.Add(chip);
            // Add the instantiated chip to the holdingChips list
            StackChip(tempHoldingChips, chip, delayBetween);
            delayBetween += 0.05f;
        }
        Debug.Log("Chip Initialized");
    }
    public void StackChip(List<GameObject> originalList, GameObject chip, float delayBetweenActions)
    {
        holdingChips.Add(chip);
        Vector3 targetLocalPosition = new(0, (holdingChips.Count - 1) * chipGap, gameManager.ZDepthTable - 0.01f * (holdingChips.Count - 1));
        Vector3 targetWorldPosition = chipStack.TransformPoint(targetLocalPosition);
        // Animate the chip moving to its target position
        actionList.TranslateObject(chip, targetWorldPosition, 0.8f, delayBetweenActions, 0, Action.EaseType.EaseOut);
        originalList.Remove(chip);
    }
    public void JoinGame()
    {
        InitializeChipsFromOutscreen();
        actionList.FadeObject(nameTMPro, Color.white, 1.2f, 0.0f, true);
        if(gameManager.gameState != GameManager.STATE_IDLE)
        {
            IsJoinMiddle = true;
        }
        else
        {
            IsIn = true;
        }
        Debug.Log(gameObject.name + "Join the game");
    }
    public void LeaveGame()
    {
        if(IsIn||IsJoinMiddle)
        {
            ThrowCards();
            RemoveChips();
            actionList.FadeObject(nameTMPro, new Color(1,1,1,0), 1.2f, 0.0f, true);
            IsIn = false;
            IsJoinMiddle = false;
            Debug.Log(gameObject.name + "Leave the game");
        }
    }
    public void AIBehavior()
    {
        if(IsIn && !IsFold && !IsJoinMiddle)
        { 
            switch(Name)
            {
                case "Random Rick":
                    if (Random.value > 0.5f)
                    {
                        Bet(1);
                        break;
                    }
                    else
                    {
                        Fold();
                        break;
                    }
                case "Crazy Carl":
                    float randomEvaluator = Random.value;
                    if(Random.value > randomEvaluator)
                    {
                        Bet(1);
                        break;
                    }
                    else
                    {
                        Fold();
                        break;
                    }
                case "Bluffy Ben":
                    if (Random.value > 0.2)
                    {
                        Bet(1);
                        break;
                    }
                    else
                    {
                        Fold();
                        break;
                    }
                case "Scary Suzie":
                    EvaluateHands();
                    if (hand.Count == 1 && handsValue.y > 11)
                    {
                        Bet(1);
                        break;
                    }
                    if (hand.Count == 2 && (handsValue.x >= 1 || handsValue.y == 13))
                    {
                        Bet(1);
                        break;
                    }
                    if (hand.Count >= 3)
                    {
                        if(handsValue.x >= 3)
                        {
                            Bet(1);
                            break;
                        }
                        else
                        {
                            Fold();
                            break;
                        }
                    }
                    else
                    {
                        Fold();
                        break;
                    }
                case "Smart Sam":
                    EvaluateHands();
                    if (hand.Count == 1 && handsValue.y > 7)
                    {
                        Bet(1);
                        break;
                    }
                    if (hand.Count == 2 && (handsValue.x >= 1 || handsValue.y > 10))
                    {
                        Bet(1);
                        break;
                    }
                    if (hand.Count >= 3)
                    {
                        if(handsValue.x >= 2)
                        {
                            Bet(1);
                            break;
                        }
                        else
                        {
                            int activePlayersNumber = 0;
                            foreach (var player in gameManager.playerList)
                            {
                                if(player.GetComponent<Player>().IsIn)
                                activePlayersNumber++;
                            }
                            if (activePlayersNumber <= 3)
                            {
                                if (handsValue.x >= 2 || handsValue.y > 11)
                                {
                                    Bet(1);
                                    break;
                                }
                                else
                                {
                                    Fold();
                                    break;
                                }
                            }
                            else
                            {
                                Fold();
                                break;
                            }
                        }
                    }
                    else
                    {
                        Fold();
                        break;
                    }
            }
        }
        else
        {
            gameManager.gameState = GameManager.STATE_IDLE;
            StartCoroutine(gameManager.CheckGameFlowState());
        }
    }
    public void Bet(int numberBet)
    {
        ThrowChips(numberBet);
        IsFold = false;
        HasActed = true;

        gameManager.gameState = GameManager.STATE_IDLE;
        StartCoroutine(gameManager.CheckGameFlowState());
    }
    
    public void Fold()
    {
        if(!IsFold)
        {
            ThrowCards();
            IsFold = true;
            HasActed = true;

            gameManager.gameState = GameManager.STATE_IDLE;
            StartCoroutine(gameManager.CheckGameFlowState());
        }
    }
    public void ResetForNextRound()
    {
        IsFold = false;
        if(IsJoinMiddle)
        {
            IsJoinMiddle = false;
        }
    }
    public void RemoveChips()
    {   
        if(holdingChips.Count > 0)
        {
            foreach(var chip in holdingChips)
            {
                actionList.TranslateObject(chip, outScreen.position, 1.8f, 1.0f, GameManager.chipsTranslateGroup, Action.EaseType.EaseIn);
                actionList.DeleteObject(chip, 2.0f, GameManager.chipsTranslateGroup);
            }
            holdingChips.Clear();
        }
    }
    public void ThrowCards()
    {
        if(IsIn && hand.Count > 0)
        {
            foreach(var card in hand)
            {
                Vector3 cardPotAngle = cardPot.GetComponentInParent<Transform>().localEulerAngles;
                //card.transform.SetParent(gameObject.GetComponent<Transform>());
                Vector3 targetPosition = RandomPositionGenerator.GenerateRandomPositionWithinCollider(cardPot);
                actionList.RotateObjectAbsolute(card, cardPotAngle + GenerateRandomScatter(new Vector3(0.0f,0.0f,0.0f),new Vector3(0.0f,0.0f,45.0f)),0.4f, 0.0f, GameManager.cardsRotateGroup);
                actionList.TranslateObject(card, targetPosition, 0.6f, 0.0f, GameManager.cardsTranslateGroup, Action.EaseType.EaseIn);
            }
            hand.Clear();
        }
    }
    public void RevealCards() // Total 0.8f sec
    {
        float delayBetween = 0.0f;
        float totalDuration = 0.0f; // Keep track of the total duration
        foreach(var card in hand)
        {
            actionList.RotateObjectAbsolute(card, new Vector3(0.0f,180.0f,0.0f),0.3f, delayBetween, GameManager.cardsRotateGroup);
            delayBetween += 0.1f;
            totalDuration = delayBetween; // Update total duration
        }
        hand.Clear();
    }
    public void ThrowChips(int numberBet)
    {
        if(IsIn && holdingChips.Count > 0)
        {
            // Ensure not to attempt to throw more chips than we have
            int numberToThrow = Mathf.Min(numberBet, holdingChips.Count);
            for (int i = 0; i< numberToThrow; i++)
            {
                Vector3 targetPosition = RandomPositionGenerator.GenerateRandomPositionWithinCollider(chipPot);

                // Translate the chip to the target position
                GameObject chipToThrow = holdingChips[^1];
                actionList.TranslateObject(chipToThrow, targetPosition, 0.6f, 0.0f, GameManager.chipsTranslateGroup, Action.EaseType.EaseIn);

                gameManager.ChipPot.Add(holdingChips[^1]);
                // Remove the chip from the list after scheduling its translation
                holdingChips.Remove(holdingChips[^1]);
            }
        }
    }
    public void EvaluateHands()
    {
        // if(IsIn && !IsJoinMiddle && !IsFold && hand.Count == 5)
        // {
            handsValue = StaticData.EvaluateHands(hand);
            //Debug.Log(this.name + handsValue);
            // Debug.Log(hand[0].GetComponent<Card>().v2_value + 
            // hand[1].GetComponent<Card>().v2_value + hand[2].GetComponent<Card>().v2_value +
            // hand[3].GetComponent<Card>().v2_value + hand[4].GetComponent<Card>().v2_value);
        // }
    }

    void Awake()
    {
        gameManagerObject = GameObject.Find("GameManager");
        gameManager = gameManagerObject.GetComponent<GameManager>();
        actionList = gameManagerObject.GetComponent<ActionList>();
        nameTMPro.GetComponent<TextMeshPro>().text = Name;
    }
}

} // namespace
