using System.Collections;
using System.Collections.Generic;
using Unity.VisualScripting;
using UnityEngine;

namespace PokerTable{
public class UIManager : MonoBehaviour
{
    GameManager gameManager;
    ActionList actionList;
    public List<GameObject> MainOptionsList = new();
    public List<GameObject> SubOptionsList = new();
    public Vector3 mainMenuPosition;

    public GameObject button1;
    public GameObject button2;
    public GameObject button3;
    public GameObject button4;
    public GameObject button5;

    public GameObject buttonHigh;
    public GameObject buttonMedium;
    public GameObject buttonLow;


    public int mainNavigator = 0;
    public int subNavigator = 0;
    public bool navigatingMain = true;
    private float delayBetween = 0.0f;

    public void UIIn()
    {
        gameManager.actionList.isPause = true;
        for (int i = 0; i < MainOptionsList.Count; i++)
        {
            actionList.ScaleObject(MainOptionsList[i], new Vector3 (1.0f,1.0f,1.0f), 0.0f, 0.0f);
            actionList.FadeObject(MainOptionsList[i], Color.white, 0.0f, 0.0f, false, 0, Action.EaseType.EaseIn);
            actionList.TranslateObject(MainOptionsList[i], new Vector3 (0, 2 - i, -9.9f), 1.0f, 0.0f, 0, Action.EaseType.EaseIn);
            actionList.RotateObjectAbsolute(MainOptionsList[i], new Vector3(0,0,360f), 1.0f, 0.0f, 0, Action.EaseType.EaseIn);
        }
        gameManager.isUIon = true;
    }
    public void UIOut()
    {
        gameManager.actionList.isPause = false;
        for (int i = 0; i < MainOptionsList.Count; i++)
        {
            if(i%2 == 1)
            actionList.TranslateObject(MainOptionsList[i], new Vector3 (6, 2-i, -9.9f), 1.0f, 0.0f, 0, Action.EaseType.EaseOut);
            else
            actionList.TranslateObject(MainOptionsList[i], new Vector3 (-6, 2-i, -9.9f), 1.0f, 0.0f, 0, Action.EaseType.EaseOut);

            actionList.RotateObjectAbsolute(MainOptionsList[i], new Vector3(0,0,360f),1.0f, 0.0f, 0, Action.EaseType.EaseOut);
        }
        for(int i = 0; i < 3; i++)
        {
            actionList.FadeObject(SubOptionsList[i], Color.clear, 1.0f, 0.0f, false, 0, Action.EaseType.EaseOut);
            actionList.TranslateObject(SubOptionsList[i], new Vector3 (0,-3, -9.9f), 1.0f, 0.0f, 0, Action.EaseType.EaseOut);
            actionList.RotateObjectAbsolute(SubOptionsList[i], new Vector3(0,0,180), 1.0f, 0.0f, 0, Action.EaseType.EaseOut);
        }
        navigatingMain = true;
        gameManager.isUIon = false;
        actionList.CallFunction(() => {
            mainNavigator = 0;
            subNavigator = 0;
        },1.0f);
    }

    void KeyUpCall()
    {
        if(gameManager.isUIon)
        {
            if(navigatingMain)
            {
                MainOptionsList[mainNavigator].GetComponent<GameButton>().Unselected();
                mainNavigator--;
                if(mainNavigator < 0)
                    mainNavigator = MainOptionsList.Count -1;
                MainOptionsList[mainNavigator].GetComponent<GameButton>().Selected();
            }
            else
            {
                SubOptionsList[subNavigator].GetComponent<GameButton>().Unselected();
                subNavigator--;
                if(subNavigator < 0)
                    subNavigator = SubOptionsList.Count -1;
                SubOptionsList[subNavigator].GetComponent<GameButton>().Selected();
                
            }
        }
    }
    void KeyDownCall()
    {
        if(gameManager.isUIon)
        {
            if(navigatingMain)
            {
                MainOptionsList[mainNavigator].GetComponent<GameButton>().Unselected();
                mainNavigator++;
                if(mainNavigator > MainOptionsList.Count -1)
                    mainNavigator = 0;
                MainOptionsList[mainNavigator].GetComponent<GameButton>().Selected();
            }
            else
            {
                SubOptionsList[subNavigator].GetComponent<GameButton>().Unselected();
                subNavigator++;
                if(subNavigator > SubOptionsList.Count -1)
                    subNavigator = 0;
                SubOptionsList[subNavigator].GetComponent<GameButton>().Selected();
            }
        }
    }
    void KeyEnterCall()
    {
        if(gameManager.isUIon)
        {
            if(navigatingMain)
            {
                MainOptionsList[mainNavigator].GetComponent<GameButton>().PressAction();
            }
            else
            {
                SubOptionsList[subNavigator].GetComponent<GameButton>().PressAction();
            }
        }
    }
    public void KeyESCCall()
    {
        if(gameManager.isUIon)
        {
            UIOut();
            MainOptionsList[mainNavigator].GetComponent<GameButton>().Unselected();
        }
        else
        {
            UIIn();
            MainOptionsList[mainNavigator].GetComponent<GameButton>().Selected();
        }
    }
    public void UITest()
    {
        delayBetween = 0.0f;
        NavigateMenus();
    }
    void NavigateMenus()
    {
        int actionsCount = UnityEngine.Random.Range(1, 10); // Ensure at least one navigation
        for (int i = 0; i < actionsCount; i++)
        {
            actionList.CallFunction(KeyDownCall, delayBetween);
            delayBetween += 0.3f;
        }

        // After navigation, decide what to do next based on the current state
        actionList.CallFunction(HandlePostNavigation, delayBetween);
    }
    void HandlePostNavigation()
    {
        delayBetween = 0.0f;
        if (mainNavigator == 4)
        {
            // Reset to navigate again
            UITest(); // Start navigation again
        }
        else
        {
            // Proceed to select the current option
            actionList.CallFunction(KeyEnterCall, delayBetween);
            delayBetween += 0.3f;

            // After selecting, check if we're navigating suboptions or if we selected 'Resume'
            actionList.CallFunction(() =>
            {
                if (!navigatingMain)
                {
                    // If in suboptions, navigate randomly then select and finally call UIOut
                    NavigateSubOptionsAndExit();
                }
                // If 'Resume' was selected or any main option that doesn't lead to suboptions, no further action is needed here
            }, delayBetween);
        }
    }

    void NavigateSubOptionsAndExit()
    {
        // Reset delayBetween for suboptions navigation
        delayBetween = 0.0f;
        int subActionsCount = UnityEngine.Random.Range(0, SubOptionsList.Count); // Randomly navigate suboptions
        for (int i = 0; i < subActionsCount; i++)
        {
            actionList.CallFunction(KeyDownCall, delayBetween); // Assuming this works for suboptions too
            delayBetween += 0.3f;
        }

        // Select the suboption
        actionList.CallFunction(KeyEnterCall, delayBetween);
        delayBetween += 0.6f;

        // Finally, call UIOut
        actionList.CallFunction(UIOut, delayBetween);
    }
    void Awake()
    {
        gameManager = FindObjectOfType<GameManager>();
        actionList = GetComponent<ActionList>(); // Assign the reference to the ActionList component
        MainOptionsList.Add(button1);
        MainOptionsList.Add(button2);
        MainOptionsList.Add(button3);
        MainOptionsList.Add(button4);
        MainOptionsList.Add(button5);
        SubOptionsList.Add(buttonHigh);
        SubOptionsList.Add(buttonMedium);
        SubOptionsList.Add(buttonLow);
        mainMenuPosition = transform.Find("MainMenuPosition").position;
    }

    void Update()
    {
        if(Input.GetKeyDown(KeyCode.R))
        {
            KeyESCCall();
        }
        if(Input.GetKeyDown(KeyCode.T))
        {
            UITest();
        }
        if(!gameManager.isAutoMode)
        {
            if(Input.GetKeyDown(KeyCode.Escape))
            {
                KeyESCCall();
            }
            if(Input.GetKeyDown(KeyCode.UpArrow))
            {
                KeyUpCall();
            }
            if(Input.GetKeyDown(KeyCode.DownArrow))
            {
                KeyDownCall();
            }
            if(Input.GetKeyDown(KeyCode.Return))
            {
                KeyEnterCall();
            }
        }
    }
}
}// namespace